<?php

//if accessed directly exit
if(!defined('ABSPATH')) exit;

/**
 * Class HudsonEdgeSkin
 */
class HudsonEdgeSkin extends HudsonEdgeSkinAbstract {
    /**
     * Skin constructor. Hooks to hudson_edge_admin_scripts_init and hudson_enqueue_admin_styles
     */
    public function __construct() {
        $this->skinName = 'edge';

        //hook to
        add_action('hudson_edge_admin_scripts_init', array($this, 'registerStyles'));
        add_action('hudson_edge_admin_scripts_init', array($this, 'registerScripts'));

        add_action('hudson_edge_enqueue_admin_styles', array($this, 'enqueueStyles'));
        add_action('hudson_edge_enqueue_admin_scripts', array($this, 'enqueueScripts'));

        add_action('hudson_edge_enqueue_meta_box_styles', array($this, 'enqueueStyles'));
        add_action('hudson_edge_enqueue_meta_box_scripts', array($this, 'enqueueScripts'));

		add_action('before_wp_tiny_mce', array($this, 'setShortcodeJSParams'), 5); // 5 is set to be same permission as Gutenberg plugin has
		$this->setIcons();
		$this->setMenuItemPosition();
    }

    /**
     * Method that registers skin scripts
     */
    public function registerScripts() {
        $this->scripts['bootstrap.min'] = 'assets/js/bootstrap.min.js';
        $this->scripts['edgtf-ui-admin'] = 'assets/js/edgtf-ui/edgtf-ui.js';
        $this->scripts['edgtf-bootstrap-select'] = 'assets/js/edgtf-ui/edgtf-bootstrap-select.min.js';

        foreach ($this->scripts as $scriptHandle => $scriptPath) {
            hudson_edge_register_skin_script($scriptHandle, $scriptPath);
        }
    }

    /**
     * Method that registers skin styles
     */
    public function registerStyles() {
        $this->styles['edgtf-bootstrap'] = 'assets/css/edgtf-bootstrap.css';
        $this->styles['edgtf-page-admin'] = 'assets/css/edgtf-page.css';
        $this->styles['edgtf-options-admin'] = 'assets/css/edgtf-options.css';
        $this->styles['edgtf-meta-boxes-admin'] = 'assets/css/edgtf-meta-boxes.css';
        $this->styles['edgtf-ui-admin'] = 'assets/css/edgtf-ui/edgtf-ui.css';
        $this->styles['edgtf-forms-admin'] = 'assets/css/edgtf-forms.css';
        $this->styles['edgtf-import'] = 'assets/css/edgtf-import.css';
        $this->styles['font-awesome-admin'] = 'assets/css/font-awesome/css/font-awesome.min.css';

        foreach ($this->styles as $styleHandle => $stylePath) {
            hudson_edge_register_skin_style($styleHandle, $stylePath);
        }

    }

	/**
	 * Method that set menu icons
	 */

	public function setIcons() {
		$this->icons = array(
			'slider' => 'dashicons-images-alt2',
			'carousel' => 'dashicons-image-flip-horizontal',
			'testimonial' => 'dashicons-format-quote',
			'portfolio' => 'dashicons-screenoptions',
			'masonry_gallery' => 'dashicons-schedule',
			'options' => $this->getSkinURI().'/assets/img/admin-logo-icon.png'
		);
	}

	/**
	 * Method that set menu item position
	 */

	public function setMenuItemPosition() {
		$this->itemPosition = array(
			'slider' => 20,
			'carousel' => 20,
			'testimonial' => 20,
			'portfolio' => 5,
			'masonry_gallery' => 20,
			'options' => 61
		);
	}

    /**
     * Method that renders options page
     *
     * @see SelectSkin::getHeader()
     * @see SelectSkin::getPageNav()
     * @see SelectSkin::getPageContent()
     */
    public function renderOptions() {
        global $hudson_edge_framework;
        $tab    = hudson_edge_get_admin_tab();
        $active_page = $hudson_edge_framework->edgtOptions->getAdminPageFromSlug($tab);
        if ($active_page == null) return;
        ?>
        <div class="edgtf-options-page edgtf-page">
            <?php $this->getHeader($active_page); ?>
            <div class="edgtf-page-content-wrapper">
                <div class="edgtf-page-content">
                    <div class="edgtf-page-navigation edgtf-tabs-wrapper vertical left clearfix">
                        <?php $this->getPageNav($tab); ?>
                        <?php $this->getPageContent($active_page); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php }

    /**
     * Method that renders header of options page.
     *
     * @param HudsonEdgeAdminPage|string $activePage used for getting achors for current page
     * @param bool $showSaveBtn whether to show save button. Should be hidden on import page
     * @param bool $showSaveNotif whether to show save notifications. Not used on import page
     *
     * @see HudsonEdgeSkinAbstract::loadTemplatePart()
     */
    public function getHeader($activePage = '', $showSaveBtn = true, $showSaveNotif = true) {
        $this->loadTemplatePart('header', array(
            'active_page' => $activePage,
            'show_save_btn' => $showSaveBtn,
            'show_save_notif' => $showSaveNotif
        ));
    }

    /**
     * Method that loads page navigation
     * @param string $tab current tab
     * @param bool $is_import_page if is import page highlighted that tab
     *
     * @see HudsonEdgeSkinAbstract::loadTemplatePart()
     */
    public function getPageNav($tab, $is_import_page = false) {
        $this->loadTemplatePart('navigation', array(
            'tab' => $tab,
            'is_import_page' => $is_import_page
        ));
    }

    /**
     * Method that loads current page content
     * @param HudsonEdgeAdminPage $page current page to load
     *
     * @see HudsonEdgeSkinAbstract::loadTemplatePart()
     */
    public function getPageContent($page) {
        $this->loadTemplatePart('content', array('page' => $page));
    }

    /**
     * Method that loads content for import page
     */
    public function getImportContent() {
        $this->loadTemplatePart('content-import');
    }

    /**
     * Method that loads anchors and save button template part
     * @param HudsonEdgeAdminPage $page current page to load
     *
     * @see HudsonEdgeSkinAbstract::loadTemplatePart()
     */
    public function getAnchors($page) {
        $this->loadTemplatePart('anchors', array('page' => $page));

    }

    /**
     * Method that renders import page
     *
     * @see SelectSkin::getHeader()
     * * @see SelectSkin::getPageNav()
     * * @see SelectSkin::getImportContent()
     */
    public function renderImport() { ?>
        <div class="edgtf-options-page edgtf-page">
            <?php $this->getHeader(null, false ,false); ?>
            <div class="edgtf-page-content-wrapper">
                <div class="edgtf-page-content">
                    <div class="edgtf-page-navigation edgtf-tabs-wrapper vertical left clearfix">
                        <?php $this->getPageNav('tabimport', true); ?>
                        <?php $this->getImportContent(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php }
}
?>